/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.loot;

import com.google.common.collect.ImmutableList;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.config.Config;
import io.strikeknight57.bca.mixin.LootPoolAccessor;
import io.strikeknight57.bca.mixin.LootTableBuilderAccessor;
import io.strikeknight57.bca.mixin.UniformLootNumberProviderAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_79;

public final class LootRollScaler {
    private LootRollScaler() {
    }

    public static void init() {
        LootTableEvents.MODIFY.register(LootRollScaler::onModifyLootTable);
        CobblemonAdditions.LOGGER.info("LootRollScaler initialized");
    }

    private static void onModifyLootTable(class_5321<class_52> key, class_52.class_53 tableBuilder, LootTableSource source, class_7225.class_7874 registries) {
        boolean setProvider;
        int scaledMax;
        int scaledMin;
        class_55.class_56 merged;
        class_55 firstPool;
        List<class_55> existingPools;
        class_2960 tableId;
        block18: {
            boolean applyRollMultiplier;
            tableId = key.method_29177();
            boolean bl = applyRollMultiplier = "bca".equals(tableId.method_12836()) && tableId.method_12832().startsWith("general/");
            if (!applyRollMultiplier) {
                return;
            }
            double factor = Config.lootRollMultiplierPercent / 100.0;
            if (factor == 1.0) {
                return;
            }
            existingPools = LootRollScaler.getExistingPools(tableBuilder);
            if (existingPools == null || existingPools.isEmpty()) {
                return;
            }
            firstPool = existingPools.get(0);
            merged = class_55.method_347();
            Object originalRolls = LootRollScaler.readRollsField(firstPool);
            Optional<float[]> maybeMinMax = LootRollScaler.extractMinMaxFromProvider(originalRolls);
            if (maybeMinMax.isEmpty()) {
                CobblemonAdditions.LOGGER.warn("Could not extract numeric min/max for {}; skipping roll scaling", (Object)tableId);
                return;
            }
            float origMin = maybeMinMax.get()[0];
            float origMax = maybeMinMax.get()[1];
            scaledMin = Math.max(1, Math.round(origMin * (float)factor));
            scaledMax = Math.max(1, Math.round(origMax * (float)factor));
            if (scaledMax < scaledMin) {
                scaledMax = scaledMin;
            }
            class_5662 scaledProvider = class_5662.method_32462((float)scaledMin, (float)scaledMax);
            setProvider = false;
            try {
                if (scaledProvider instanceof class_5658) {
                    merged.method_352((class_5658)scaledProvider);
                    setProvider = true;
                    break block18;
                }
                for (Method m : class_55.class_56.class.getMethods()) {
                    Class<?> param;
                    if (!m.getName().equals("rolls") || m.getParameterCount() != 1 || !(param = m.getParameterTypes()[0]).isAssignableFrom(scaledProvider.getClass())) continue;
                    m.invoke((Object)merged, scaledProvider);
                    setProvider = true;
                    break;
                }
            }
            catch (Throwable t) {
                setProvider = false;
            }
        }
        if (!setProvider) {
            merged.method_352((class_5658)class_44.method_32448((float)scaledMin));
            CobblemonAdditions.LOGGER.warn("Falling back to constant rolls={} for {} because scaled provider could not be applied", (Object)scaledMin, (Object)tableId);
        } else {
            CobblemonAdditions.LOGGER.debug("Applied scaled rolls to {} -> min={} max={}", new Object[]{tableId, scaledMin, scaledMax});
        }
        try {
            List<class_79> existingEntries = ((LootPoolAccessor)firstPool).getEntries();
            if (existingEntries != null) {
                for (class_79 e : existingEntries) {
                    merged.with(e);
                }
            }
        }
        catch (Throwable existingEntries) {
            // empty catch block
        }
        ImmutableList.Builder newPoolsBuilder = ImmutableList.builder();
        newPoolsBuilder.add((Object)merged.method_355());
        for (int i = 1; i < existingPools.size(); ++i) {
            newPoolsBuilder.add((Object)existingPools.get(i));
        }
        try {
            ((LootTableBuilderAccessor)tableBuilder).setPoolsBuilder((ImmutableList.Builder<class_55>)newPoolsBuilder);
        }
        catch (Throwable t) {
            CobblemonAdditions.LOGGER.warn("Failed to replace pools builder while applying scaled rolls for {}: {}", (Object)tableId, (Object)t.getMessage());
        }
    }

    private static Optional<float[]> extractMinMaxFromProvider(Object provider) {
        if (provider == null) {
            return Optional.empty();
        }
        if (provider instanceof class_44) {
            try {
                float v = ((class_44)provider).comp_1895();
                return Optional.of(new float[]{v, v});
            }
            catch (Throwable v) {
                // empty catch block
            }
        }
        if (provider instanceof class_5662) {
            try {
                UniformLootNumberProviderAccessor accessor = (UniformLootNumberProviderAccessor)provider;
                class_5658 minInner = accessor.getMin();
                class_5658 maxInner = accessor.getMax();
                Float minVal = LootRollScaler.extractNumericFromProvider(minInner);
                Float maxVal = LootRollScaler.extractNumericFromProvider(maxInner);
                if (minVal != null && maxVal != null) {
                    return Optional.of(new float[]{minVal.floatValue(), maxVal.floatValue()});
                }
                return Optional.empty();
            }
            catch (Throwable ignored) {
                return Optional.empty();
            }
        }
        Float[] heur = LootRollScaler.heuristicNumericExtraction(provider);
        if (heur != null) {
            return Optional.of(new float[]{heur[0].floatValue(), heur[1].floatValue()});
        }
        return Optional.empty();
    }

    private static Float extractNumericFromProvider(Object provider) {
        if (provider == null) {
            return null;
        }
        if (provider instanceof class_44) {
            try {
                return Float.valueOf(((class_44)provider).comp_1895());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Class<?> cls = provider.getClass();
        try {
            Method valueMethod = cls.getMethod("value", new Class[0]);
            Object r = valueMethod.invoke(provider, new Object[0]);
            if (r instanceof Number) {
                return Float.valueOf(((Number)r).floatValue());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException valueMethod) {
            // empty catch block
        }
        try {
            Field f = cls.getDeclaredField("value");
            f.setAccessible(true);
            Object vobj = f.get(provider);
            if (vobj instanceof Number) {
                return Float.valueOf(((Number)vobj).floatValue());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException f) {
            // empty catch block
        }
        try {
            Field[] fields;
            for (Field f : fields = cls.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    Object val = f.get(provider);
                    if (!(val instanceof Number)) continue;
                    return Float.valueOf(((Number)val).floatValue());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Float[] heuristicNumericExtraction(Object provider) {
        Float b;
        Float a;
        if (provider == null) {
            return null;
        }
        Class<?> cls = provider.getClass();
        try {
            Field[] fields = cls.getDeclaredFields();
            a = null;
            b = null;
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field f = fieldArray[i];
                try {
                    f.setAccessible(true);
                    Object val = f.get(provider);
                    if (!(val instanceof Number)) continue;
                    if (a == null) {
                        a = Float.valueOf(((Number)val).floatValue());
                        continue;
                    }
                    if (b != null) continue;
                    b = Float.valueOf(((Number)val).floatValue());
                    break;
                }
                catch (Throwable val) {
                    // empty catch block
                }
            }
            if (a != null && b != null) {
                float min = Math.min(a.floatValue(), b.floatValue());
                float max = Math.max(a.floatValue(), b.floatValue());
                return new Float[]{Float.valueOf(min), Float.valueOf(max)};
            }
        }
        catch (Throwable fields) {
            // empty catch block
        }
        try {
            Method[] methods = cls.getDeclaredMethods();
            a = null;
            b = null;
            for (Method m : methods) {
                if (m.getParameterCount() != 0) continue;
                try {
                    m.setAccessible(true);
                    Object ret = m.invoke(provider, new Object[0]);
                    if (!(ret instanceof Number)) continue;
                    if (a == null) {
                        a = Float.valueOf(((Number)ret).floatValue());
                        continue;
                    }
                    if (b != null) continue;
                    b = Float.valueOf(((Number)ret).floatValue());
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (a != null && b != null) {
                float min = Math.min(a.floatValue(), b.floatValue());
                float max = Math.max(a.floatValue(), b.floatValue());
                return new Float[]{Float.valueOf(min), Float.valueOf(max)};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static Object readRollsField(class_55 pool) {
        try {
            return ((LootPoolAccessor)pool).getRolls();
        }
        catch (Throwable t) {
            CobblemonAdditions.LOGGER.error("Failed to read rolls field from LootPool", t);
            return null;
        }
    }

    private static List<class_55> getExistingPools(class_52.class_53 tableBuilder) {
        ImmutableList.Builder<class_55> poolsBuilder = ((LootTableBuilderAccessor)tableBuilder).getPoolsBuilder();
        return poolsBuilder.build();
    }
}

