/*
 * Decompiled with CFR 0.152.
 */
package com.discordbutton;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static String discordUrl = "https://discord.gg/PYrvp5JUDX";
    public static String websiteUrl = "https://mhcraft.fr/";

    private static File getConfigFile() {
        return new File(class_310.method_1551().field_1697, "config/boutondiscord.json");
    }

    public static void load() {
        try {
            File configFile = Config.getConfigFile();
            if (!configFile.exists()) {
                Config.save();
                return;
            }
            try (FileReader reader = new FileReader(configFile);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data.discord_url != null) {
                    discordUrl = data.discord_url;
                }
                if (data.website_url != null) {
                    websiteUrl = data.website_url;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            File configFile = Config.getConfigFile();
            configFile.getParentFile().mkdirs();
            ConfigData data = new ConfigData();
            data.discord_url = discordUrl;
            data.website_url = websiteUrl;
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigData {
        public String discord_url;
        public String website_url;

        private ConfigData() {
        }
    }
}

