/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.battle;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.BattleCloneProperty;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleContext;
import com.gitlab.srcmc.rctapi.api.battle.BattleContextValidator;
import com.gitlab.srcmc.rctapi.api.battle.BattleFormat;
import com.gitlab.srcmc.rctapi.api.battle.BattleFormatProvider;
import com.gitlab.srcmc.rctapi.api.battle.BattleRules;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.gitlab.srcmc.rctapi.api.events.EventContext;
import com.gitlab.srcmc.rctapi.api.events.Events;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerBag;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerPlayer;
import com.gitlab.srcmc.rctapi.api.util.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class BattleManager {
    private BattleContextValidator validator = new BattleContextValidator();
    private Map<UUID, BattleState> battleStates = new HashMap<UUID, BattleState>();
    private BattleRules defaultRules = new BattleRules.Builder().build();
    private EventContext eventContext;
    private static Map<UUID, BattleManager> battleToManager = new HashMap<UUID, BattleManager>();
    private static final int MAX_BATTLE_QUERY_WAIT_TICKS = 60;
    private static final Map<PokemonBattle, int[]> BATTLE_QUERY_TO_CANCEL = new HashMap<PokemonBattle, int[]>();

    public BattleManager() {
        this(new EventContext());
    }

    public BattleManager(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    @Deprecated(since="0.11.0")
    public boolean startSingle(@NotNull Trainer participant1, @NotNull Trainer participant2) {
        return this.startSingle(participant1, participant2, this.getDefaultRules());
    }

    @Deprecated(since="0.11.0")
    public boolean startSingle(@NotNull Trainer participant1, @NotNull Trainer participant2, @NotNull BattleRules battleRules) {
        return this.start(List.of(participant1), List.of(participant2), BattleFormat.GEN_9_SINGLES, battleRules);
    }

    @Deprecated(since="0.11.0")
    public boolean startDouble(@NotNull Trainer participant1, @NotNull Trainer participant2) {
        return this.startDouble(participant1, participant2, this.getDefaultRules());
    }

    @Deprecated(since="0.11.0")
    public boolean startDouble(@NotNull Trainer participant1, @NotNull Trainer participant2, @NotNull BattleRules battleRules) {
        return this.start(List.of(participant1), List.of(participant2), BattleFormat.GEN_9_DOUBLES, battleRules);
    }

    @Deprecated(since="0.11.0")
    public boolean startTriple(@NotNull Trainer participant1, @NotNull Trainer participant2) {
        return this.startTriple(participant1, participant2, this.getDefaultRules());
    }

    @Deprecated(since="0.11.0")
    public boolean startTriple(@NotNull Trainer participant1, @NotNull Trainer participant2, @NotNull BattleRules battleRules) {
        return this.start(List.of(participant1), List.of(participant2), BattleFormat.GEN_9_TRIPLES, battleRules);
    }

    @Deprecated(since="0.11.0")
    public boolean startMulti(@NotNull Trainer participant1_l, @NotNull Trainer participant1_r, @NotNull Trainer participant2_l, @NotNull Trainer participant2_r) {
        return this.startMulti(participant1_l, participant1_r, participant2_l, participant2_r, this.getDefaultRules());
    }

    @Deprecated(since="0.11.0")
    public boolean startMulti(@NotNull Trainer participant1_l, @NotNull Trainer participant1_r, @NotNull Trainer participant2_l, @NotNull Trainer participant2_r, @NotNull BattleRules battleRules) {
        return this.start(List.of(participant1_l, participant1_r), List.of(participant2_l, participant2_r), BattleFormat.GEN_9_MULTI, battleRules);
    }

    @Deprecated(since="0.11.0")
    public boolean start(@NotNull List<Trainer> participants1, @NotNull List<Trainer> participants2, @NotNull BattleFormatProvider battleFormat, @NotNull BattleRules battleRules) {
        return this.startBattle(participants1, participants2, battleFormat, battleRules) != null;
    }

    @Deprecated(since="0.14.6")
    public boolean start(@NotNull List<Trainer> participants1, @NotNull List<Trainer> participants2, @NotNull BattleFormat battleFormat, @NotNull BattleRules battleRules) {
        return this.start(participants1, participants2, (BattleFormatProvider)battleFormat, battleRules);
    }

    public UUID startBattle(@NotNull List<Trainer> participants1, @NotNull List<Trainer> participants2, @NotNull BattleFormatProvider battleFormat, @NotNull BattleRules battleRules) {
        BattleSide side1 = BattleManager.toBattleSide(participants1, battleFormat, battleRules);
        BattleSide side2 = BattleManager.toBattleSide(participants2, battleFormat, battleRules);
        ErroredBattleStart errors = this.validator.validate(new ErroredBattleStart(), new BattleContext(participants1, participants2, side1, side2, battleFormat));
        UUID[] uuid = new UUID[]{null};
        if (errors.isEmpty()) {
            BattleRegistry.startBattle((com.cobblemon.mod.common.battles.BattleFormat)battleFormat.getCobblemonBattleFormat(), (BattleSide)side1, (BattleSide)side2, (boolean)true).ifErrored(error -> {
                ModCommon.LOG.warn("Failed to start battle: " + BattleManager.toBattleArgsString(participants1, participants2));
                BattleManager.sendErrors(error, participants1, participants2);
                return Unit.INSTANCE;
            }).ifSuccessful(battle -> {
                battleToManager.put(battle.getBattleId(), this);
                uuid[0] = battle.getBattleId();
                battle.getOnEndHandlers().add(b -> {
                    BattleManager.queryToEnd(b, 60);
                    return Unit.INSTANCE;
                });
                this.eventContext.fire(Events.BATTLE_STARTED.create(this.battleStates.put(battle.getBattleId(), new BattleState((PokemonBattle)battle, battleFormat, battleRules, participants1, participants2))));
                return Unit.INSTANCE;
            });
        } else {
            ModCommon.LOG.warn("Failed to validate battle: " + BattleManager.toBattleArgsString(participants1, participants2));
            BattleManager.sendErrors(errors, participants1, participants2);
        }
        return uuid[0];
    }

    @Deprecated(since="0.14.6")
    public UUID startBattle(@NotNull List<Trainer> participants1, @NotNull List<Trainer> participants2, @NotNull BattleFormat battleFormat, @NotNull BattleRules battleRules) {
        return this.startBattle(participants1, participants2, (BattleFormatProvider)battleFormat, battleRules);
    }

    public boolean end(UUID battleId) {
        return this.end(battleId, false);
    }

    public boolean end(UUID battleId, boolean forced) {
        BattleState state = this.battleStates.get(battleId);
        if (state != null) {
            PokemonBattle battle = state.getBattle();
            if (forced || battle == null || battle.getEnded()) {
                boolean bl = state.endForced = battle != null && !battle.getEnded();
                if (state.endForced) {
                    battle.stop();
                }
                state.getParticipants1().stream().filter(t -> {
                    TrainerNPC n;
                    return t instanceof TrainerNPC && !(n = (TrainerNPC)t).getEntity().method_5805();
                }).map(t -> (TrainerNPC)t).forEach(t -> t.setEntity(TrainerNPC.getDummyEntity(t.getEntity().method_5682())));
                state.getParticipants2().stream().filter(t -> {
                    TrainerNPC n;
                    return t instanceof TrainerNPC && !(n = (TrainerNPC)t).getEntity().method_5805();
                }).map(t -> (TrainerNPC)t).forEach(t -> t.setEntity(TrainerNPC.getDummyEntity(t.getEntity().method_5682())));
                for (BattleActor actor : state.getBattle().getActors()) {
                    TrainerEntityBattleActor eb;
                    if (!(actor instanceof TrainerEntityBattleActor) || (eb = (TrainerEntityBattleActor)actor).getEntity().method_5805()) continue;
                    actor.getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).map(ap -> ap.getBattlePokemon().getEffectedPokemon()).forEach(Pokemon::tryRecallWithAnimation);
                }
                this.battleStates.remove(battleId);
                battleToManager.remove(battleId);
                this.eventContext.fire(Events.BATTLE_ENDED.create(state));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public BattleRules getDefaultRules() {
        return this.defaultRules;
    }

    public void setDefaultRules(@NotNull BattleRules defaultRules) {
        this.defaultRules = defaultRules;
    }

    public BattleState getState(UUID battleId) {
        return this.battleStates.get(battleId);
    }

    public Collection<BattleState> getStates() {
        return this.battleStates.values();
    }

    public static void tick() {
        Iterator<Map.Entry<PokemonBattle, int[]>> it = BATTLE_QUERY_TO_CANCEL.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PokemonBattle, int[]> e = it.next();
            int[] nArray = e.getValue();
            nArray[0] = nArray[0] - 1;
            if (nArray[0] >= 0) continue;
            BattleManager.forceEnd(e.getKey());
            it.remove();
        }
    }

    public static void queryToEnd(PokemonBattle battle) {
        BATTLE_QUERY_TO_CANCEL.put(battle, new int[]{0});
    }

    public static void queryToEnd(PokemonBattle battle, int ticks) {
        BATTLE_QUERY_TO_CANCEL.put(battle, new int[]{ticks});
    }

    public static BattleManager of(@NotNull PokemonBattle battle) {
        return battleToManager.get(battle.getBattleId());
    }

    private static void forceEnd(PokemonBattle battle) {
        BattleManager bm = BattleManager.of(battle);
        if (bm != null) {
            bm.end(battle.getBattleId(), true);
            BattleStates.notifyBattleEnded(battle);
        }
    }

    private static void sendErrors(ErroredBattleStart errors, List<Trainer> participants1, List<Trainer> participants2) {
        for (List<Trainer> participants : List.of(participants1, participants2)) {
            for (Trainer participant : participants) {
                if (!(participant instanceof TrainerPlayer)) continue;
                TrainerPlayer trainerPlayer = (TrainerPlayer)participant;
                errors.sendTo((class_1297)trainerPlayer.getPlayer(), t -> t);
            }
        }
    }

    private static BattleSide toBattleSide(List<Trainer> participants, BattleFormatProvider format, BattleRules rules) {
        ArrayList<BattleActor> battleActors = new ArrayList<BattleActor>();
        int adjustLevel = format.getCobblemonBattleFormat().getAdjustLevel();
        for (Trainer participant : participants) {
            BattleActor actor;
            if (participant instanceof TrainerPlayer) {
                TrainerPlayer trainerPlayer = (TrainerPlayer)participant;
                actor = BattleManager.toBattleActor(trainerPlayer, adjustLevel > 0);
                BattleManager.initParty(actor, rules.getHealPlayers(), rules.getAdjustPlayerLevels() ? adjustLevel : 0);
                battleActors.add(actor);
                continue;
            }
            if (participant instanceof TrainerNPC) {
                TrainerNPC trainerNPC = (TrainerNPC)participant;
                actor = BattleManager.toBattleActor(trainerNPC);
                BattleManager.initParty(actor, true, rules.getAdjustNPCLevels() ? adjustLevel : 0);
                battleActors.add(actor);
                continue;
            }
            ModCommon.LOG.warn(String.format("invalid participant '%s', must extend from %s or %s", participant.getName(), TrainerPlayer.class.getName(), TrainerNPC.class.getName()));
        }
        return new BattleSide(battleActors.toArray(new BattleActor[battleActors.size()]));
    }

    private static List<BattlePokemon> toBattlePokemons(boolean isPlayer, boolean clone, Pokemon ... pokemons) {
        ArrayList<BattlePokemon> battlePokemons = new ArrayList<BattlePokemon>();
        PlayerPartyStore tempPlayerStore = null;
        if (isPlayer && clone) {
            UUID playerUUID = pokemons[0].getOwnerUUID();
            if (playerUUID == null) {
                throw new NullPointerException("Player UUID doesn't exist");
            }
            tempPlayerStore = new PlayerPartyStore(playerUUID);
        }
        for (Pokemon pokemon : pokemons) {
            Function1 post;
            Pokemon effected;
            if (pokemon.isFainted()) continue;
            if (clone) {
                effected = pokemon.clone(true, null);
                BattleCloneProperty.INSTANCE.isBattleClone().apply(effected);
                UncatchableProperty.INSTANCE.uncatchable().apply(effected);
                if (isPlayer) {
                    tempPlayerStore.add(effected);
                }
                post = entity -> {
                    entity.recallWithAnimation();
                    return Unit.INSTANCE;
                };
            } else {
                effected = pokemon;
                post = entity -> Unit.INSTANCE;
            }
            battlePokemons.add(new BattlePokemon(pokemon, effected, post));
        }
        return battlePokemons;
    }

    private static void initParty(BattleActor actor, boolean heal, int adjustLevel) {
        if (adjustLevel > 0 || heal) {
            for (BattlePokemon pokemon : actor.getPokemonList()) {
                Pokemon effected = pokemon.getEffectedPokemon();
                if (adjustLevel > 0) {
                    effected.setLevel(adjustLevel);
                }
                if (!heal) continue;
                effected.heal();
            }
        }
    }

    private static BattleActor toBattleActor(TrainerPlayer participant, boolean clone) {
        PlayerBattleActor actor = new PlayerBattleActor(participant.getPlayer().method_5667(), BattleManager.toBattlePokemons(true, clone, participant.getTeam()));
        actor.setBattleTheme(CobblemonSounds.PVN_BATTLE.method_14833());
        return actor;
    }

    private static BattleActor toBattleActor(TrainerNPC participant) {
        return new TrainerEntityBattleActor(participant.getName(), participant.getEntity(), participant.getEntity().method_5667(), BattleManager.toBattlePokemons(false, true, participant.getTeam()), participant.getBag().clone(), participant.getBattleAI());
    }

    private static String toBattleArgsString(List<Trainer> participants1, List<Trainer> participants2) {
        StringBuilder sb = new StringBuilder();
        if (participants1.size() > 0) {
            sb.append(participants1.getFirst().getName());
        }
        participants1.stream().skip(1L).forEach(p -> sb.append(", ").append(p.getName()));
        sb.append(" vs ");
        if (participants2.size() > 0) {
            sb.append(participants2.getFirst().getName());
        }
        participants2.stream().skip(1L).forEach(p -> sb.append(", ").append(p.getName()));
        return sb.toString();
    }

    public static class TrainerEntityBattleActor
    extends AIBattleActor
    implements EntityBackedBattleActor<class_1309> {
        private final Text name;
        private final class_1309 entity;
        private final TrainerBag bag;

        public TrainerEntityBattleActor(String name, class_1309 entity, UUID uuid, List<BattlePokemon> pokemonList, TrainerBag bag, BattleAI artificialDecider) {
            this(Text.literal(name), entity, uuid, pokemonList, bag, artificialDecider);
        }

        public TrainerEntityBattleActor(Text name, class_1309 entity, UUID uuid, List<BattlePokemon> pokemonList, TrainerBag bag, BattleAI artificialDecider) {
            super(uuid, pokemonList, artificialDecider);
            this.name = name;
            this.bag = bag;
            this.entity = entity;
        }

        @NotNull
        public TrainerBag getBag() {
            return this.bag;
        }

        public class_1309 getEntity() {
            return this.entity;
        }

        @NotNull
        public ActorType getType() {
            return ActorType.NPC;
        }

        @NotNull
        public class_5250 getName() {
            return this.name.getComponent(new Object[0]);
        }

        @NotNull
        public class_5250 nameOwned(@NotNull String s) {
            return LocalizationUtilsKt.battleLang((String)"owned_pokemon", (Object[])new Object[]{this.getName(), this.name});
        }

        public class_243 getInitialPos() {
            return this.entity.method_19538();
        }
    }
}

