/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.errors.RCTErrors;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.events.EventContext;
import com.gitlab.srcmc.rctapi.api.events.Events;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.models.converter.PokemonModelConverter;
import com.gitlab.srcmc.rctapi.api.models.converter.TrainerModelConverter;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerPlayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TrainerRegistry {
    private Map<String, Trainer> trainers = new HashMap<String, Trainer>();
    private Set<String> trainerNPCs = new HashSet<String>();
    private Set<String> trainerPlayers = new HashSet<String>();
    private TrainerModelConverter tmc;
    private EventContext eventContext;
    private String id;
    private static char OTID_SEPARATOR = (char)35;

    public TrainerRegistry() {
        this("");
    }

    public TrainerRegistry(@NotNull String id) {
        this(id, new EventContext());
    }

    public TrainerRegistry(@NotNull String id, @NotNull EventContext eventContext) {
        this.id = id;
        this.eventContext = eventContext;
    }

    public void init(@NotNull MinecraftServer server) {
        this.tmc = new TrainerModelConverter(server, new PokemonModelConverter());
        this.clear();
    }

    @NotNull
    public TrainerPlayer registerPlayer(@NotNull String trainerId, @NotNull class_3222 player) {
        return this.registerPlayer(trainerId, new TrainerPlayer(player));
    }

    @NotNull
    public <T extends TrainerPlayer> T registerPlayer(@NotNull String trainerId, @NotNull T trainer) {
        this.trainerPlayers.add(trainerId);
        this.register(trainerId, trainer);
        return trainer;
    }

    @NotNull
    public TrainerNPC registerNPC(@NotNull String trainerId, @NotNull TrainerModel model) {
        RCTErrors<RCTException> errors = RCTErrors.create();
        TrainerNPC trainer = this.tmc.toTarget(model, errors);
        this.registerNPC(trainerId, trainer);
        errors.check();
        return trainer;
    }

    @NotNull
    public <T extends TrainerNPC> T registerNPC(@NotNull String trainerId, @NotNull T trainer) {
        trainer.initTeam(this.toOTId(trainerId));
        this.trainerNPCs.add(trainerId);
        this.register(trainerId, trainer);
        return trainer;
    }

    public Trainer unregisterById(@NotNull String trainerId) {
        Trainer trainer = this.trainers.remove(trainerId);
        if (trainer != null && this.trainerPlayers.remove(trainerId) | this.trainerNPCs.remove(trainerId)) {
            this.eventContext.fire(Events.TRAINER_UNREGISTRED.create(Map.entry(trainerId, trainer)));
        }
        return trainer;
    }

    public Trainer getById(@NotNull String trainerId) {
        return this.getById(trainerId, Trainer.class);
    }

    public <T extends Trainer> T getById(@NotNull String trainerId, @NotNull Class<T> type) {
        Trainer trainer = this.trainers.get(trainerId);
        if (trainer == null) {
            return null;
        }
        if (!type.isInstance(trainer)) {
            throw new IllegalArgumentException(String.format("invalid trainer type '%s' for '%s', expected '%s'", trainer.getClass().getName(), trainerId, type.getName()));
        }
        return (T)((Trainer)type.cast(trainer));
    }

    public Trainer getByOT(@NotNull Pokemon pkmn) {
        return this.getByOT(pkmn, Trainer.class);
    }

    public <T extends Trainer> T getByOT(@NotNull Pokemon pkmn, @NotNull Class<T> type) {
        String[] parts;
        String otId = pkmn.getOriginalTrainer();
        String[] stringArray = parts = otId != null ? otId.split(String.valueOf(OTID_SEPARATOR)) : new String[]{};
        if (parts.length == 2 && parts[0].equals(this.id)) {
            return this.getById(parts[1], type);
        }
        return null;
    }

    @NotNull
    public Set<String> getIds() {
        return this.trainers.keySet();
    }

    public String getId(class_1309 entity) {
        for (Map.Entry<String, Trainer> entry : this.trainers.entrySet()) {
            class_1309 tnpc = entry.getValue().getEntity();
            if (tnpc == null || !tnpc.equals((Object)entity)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void clear() {
        this.clearNPCs();
        this.clearPlayers();
    }

    public void clearNPCs() {
        this.trainerNPCs.forEach(trainerId -> this.eventContext.fire(Events.TRAINER_UNREGISTRED.create(Map.entry(trainerId, this.trainers.remove(trainerId)))));
        this.trainerNPCs.clear();
    }

    public void clearPlayers() {
        this.trainerPlayers.forEach(trainerId -> this.eventContext.fire(Events.TRAINER_UNREGISTRED.create(Map.entry(trainerId, this.trainers.remove(trainerId)))));
        this.trainerPlayers.clear();
    }

    protected String toOTId(String trainerId) {
        return String.format("%s%c%s", this.id, Character.valueOf(OTID_SEPARATOR), trainerId);
    }

    private void register(String trainerId, Trainer trainer) {
        if (this.trainers.putIfAbsent(trainerId, trainer) != null) {
            throw new IllegalArgumentException(String.format("trainer already registered '%s'", trainerId));
        }
        this.eventContext.fire(Events.TRAINER_REGISTRED.create(Map.entry(trainerId, trainer)));
    }
}

